<?php
$conf_file = dirname(__FILE__).'/conf.ini';
iniFile::read($conf_file);

class dcVideo
{
    
/* dcDisplayBlogmark
 * Affichage de la liste blogmark avec titres asssocis aux mots-cls
 *
 * @param integer $list_nbr       Nombre d'entres  afficher (10)
 * @param string  $tag_list       Filtre des mots-cls ('web')
 * @param string  $tag_title      Titres des mots-cls ('Blogmarks')
 * @param boolean $sort           Tri alphabtique des listes  l'affichage sur
 *                                le blog (false)
 * @param boolean $displayCenter Affichage ou non du commentaire  la suite 
 *                                du titre-lien (false)
 * @param boolean $hreflang       Affichage ou non de hreflang (false)
 * @param boolean $displaycustom  Affichage ou non du champ custom (false)
 * @param string  $fmtdt          Format d'affichage suivant PHP date() "d/m/Y" ('')
 * @param integer $titlel         Longueur du titre  afficher (40)
 * @param integer $cmtl           Longueur du commentaire court  afficher(100)
 * @param string  $block          Format d'affichage de la liste ('<ul>%s</ul>')
 * @param string  $item           Format d'affichage d'un niveau ('<li>%s</li>')
 * @param string  $sep            Sparateur ('&nbsp;-&nbsp;')
 * @param string  $head           Format d'affichage du titre ('<h2>%s</h2>')
 */
function dcDisplayVideo($list_nbr=10, $tag_list = 'web', $tag_title = 'Videos',
         $sort = false, $displayCenter = false,
         $hreflang = false, $displaycustom = false,
         $fmtdt = '', $titlel = 40, $cmtl = 100,
         $block = '<ul>%s</ul>', $item = '<li>%s</li>', $sep = '&nbsp;-&nbsp;',
         $head = '<h2>%s</h2>')
{
  $dftag = 'web'; $str = ''; $index_list = 1;
  $str_tag = array(); $tag_txt = array();
  if (!is_array($tag_title)) {
    if ($tag_title == '') { $tag_title = array($dftag => ucfirst($dftag));
    } else { $tag_title = array($dftag => $tag_title);
    }
  }
  if (is_null($tag_list)) { $tag_list = '*'; }
  $tag_list = trim($tag_list);
  if (substr($tag_list, 0, 1) == '-') {
    $positive_list = false;
    $tag_list = strtolower(trim(substr($tag_list, 1)));
  } else {
    $positive_list = true;
  }
  if ($tag_list == '') { $tag_list = $dftag; }
  while(!dcVideo::eof()) {
    $bm_via = ''; $bm_tag_txt = '';
    $bm_custom = trim(dcVideo::get('custom'));
    $bm_pos = strpos(strtolower($bm_custom), 'http://');
    if ($bm_pos === false) { $bm_pos = strpos(strtolower($bm_custom), 'mailto:'); }
    if ($bm_pos === false) { $bm_pos = strpos(strtolower($bm_custom), 'ftp://'); }
    if ($bm_pos === false) { $bm_pos = strpos(strtolower($bm_custom), 'news://'); }
    if ($bm_pos !== false) {
      $bm_via = substr($bm_custom, $bm_pos);
      $bm_via = '<span>&nbsp;::&nbsp;<a href="' . $bm_via . '" title="' . $bm_via .'">via</a></span>';
      $bm_custom = trim(substr($bm_custom, 0, $bm_pos));
    }
    if ($bm_custom == '') { $bm_custom = $dftag; }
    $words  = explode(' ', $bm_custom);
    $bm_tag = $words[0];
    if (ereg("^[0-9a-z]+$", $words[0])) { $words[0] = ucfirst($words[0]); }
    if (!array_key_exists($bm_tag, $tag_title)) {
      $array_temp = array( $bm_tag => $words[0]);
      $tag_title = array_merge ($tag_title, $array_temp);
    }
    if ($tag_list != '*') {
      $tag_found = preg_match('/\b' . strtolower($bm_tag) . '\b/i', $tag_list);
      if ((!$tag_found) AND $positive_list) { dcVideo::moveNext(); continue; }
      if ($tag_found AND (!$positive_list)) { dcVideo::moveNext(); continue; }
    }
    $hrf = ''; $comment = ''; $cus = ''; $cmt = ''; $cmts = '';
    $bm_title = dcVideo::get('title',$titlel);
    $cmts = $bm_title;
    if (dcVideo::get('comment') != '') {
      # nettoyage du commentaire pour affichage en HTML
      $cmt = htmlspecialchars(strtr(dcVideo::get('comment'),chr(10).chr(13),'  '));
      $cmts = util::cutString($cmt,$cmtl);
    }
    if ($hreflang AND (dcVideo::get('language') != '')) {
      $hrf = ' hreflang="' . dcVideo::get('language') . '"'; }
    if ($displayCenter) { 
      if ($displaycustom AND ($bm_tag != $dftag)) { $comment .=  $sep . $bm_tag; }
      if ($fmtdt != '') { $comment .= $sep . dcVideo::get('date', $fmtdt); }
      if ($cmt != '') { $comment .= $sep . $cmt; }
    }
    $str_tag_temp = sprintf($item, '<a href="' . dcVideo::get('url') . '"' .
      ' title="' . $cmts . '"' . $hrf . '>' . $bm_title . '</a>' . $comment  . $bm_via);
    if ($sort) { $str_tag_temp = '<s>' . strtolower($bm_title) . '</s>' . $str_tag_temp; }
    if (array_key_exists($tag_title[$bm_tag], $str_tag)) {
    # le titre est la cl de $str_tag
      $str_tag[$tag_title[$bm_tag]] .= $str_tag_temp;
    } else {
      $array_temp = array( $tag_title[$bm_tag] => $str_tag_temp);
      $str_tag = array_merge ($str_tag, $array_temp);
    }
    if ($index_list++ >= $list_nbr) { break; }
    dcVideo::moveNext();
  }
  if (!empty($str_tag)) {
    if ($sort) { ksort($str_tag); }
    foreach($str_tag as $cle=>$val) {
      if ($head != '') { $str .= sprintf($head, str_replace('_', ' ', $cle)); }
      if ($sort) {
        $str_tag_temp = '';
        $array_temp = explode('<s>', $val); 
        asort($array_temp);
        foreach($array_temp as $cle_s=>$val_s) {
          if ($val_s != '') { $str_tag_temp .= substr($val_s, 4 + strpos($val_s, '</s>')); }
        }
        $str .= sprintf($block, $str_tag_temp);
      } else {
        $str .= sprintf($block, $val); # preg_replace("/(<s>)(.*?)(<\/s>)/", "", $val)
      }
    }
    echo $str;
  }
  dcVideo::moveStart(); # repositionne en debut du recordset pour liste suivante
} # fin dcDisplayVideo

function _retrieveData()
{
    global $con;
    $sql = 'SELECT * FROM `' . DB_PREFIX . 'video`  ORDER BY `id` DESC LIMIT 0,' . dcVideo_feed_items_limit;
    $GLOBALS['DC_VIDEO_DATA'] = $con->select($sql);
}

function eof()
{
    if (!isset($GLOBALS['DC_VIDEO_DATA'])) {
        dcVideo::_retrieveData();
    }
    return $GLOBALS['DC_VIDEO_DATA']->EOF();
}

function moveNext()
{
    return $GLOBALS['DC_VIDEO_DATA']->moveNext();
}

function moveStart()
{
    return $GLOBALS['DC_VIDEO_DATA']->moveStart();
}

function get($element, $option = null)
{
    switch($element){
      case 'date':
        {            
            $date = $GLOBALS['DC_VIDEO_DATA']->field('date');
            if (!is_null($option)) {
                return date($option, strtotime($date));
            } else {
                return $date;
            }
        break;
        }

      case 'title':
        {            
            $title = $GLOBALS['DC_VIDEO_DATA']->field('title');
            if (!is_null($option)) {
                if (strlen($title) > $option) {
                    $title = substr($title, 0, $option);
                    return htmlspecialchars($title) . '&#8230;';
                } else {
                    return htmlspecialchars($title);
                }                    
            } else {
                return htmlspecialchars($title);
            }
        break;
        }

      case 'url':
        {            
        return htmlspecialchars($GLOBALS['DC_VIDEO_DATA']->field('url'));
        break;
        }
        
        case 'language':
        {            
        return $GLOBALS['DC_VIDEO_DATA']->field('language');
        break;
        }

        case 'comment':
        {            
        return htmlspecialchars($GLOBALS['DC_VIDEO_DATA']->field('comment'));
        break;
        }

        case 'custom':
        {            
        return $GLOBALS['DC_VIDEO_DATA']->field('custom');
        break;
        }

      default:
        {
        return false;
        }
    }
}

} # fin class dcVideo

// permet de construire l'objet flash (le lecteur) avec les options selectionnes
class dcVideoPlayer {

	function getPlayerCode($playerDirectory,$bgColor,$width,$height,$displayCenter){

		$blogUrl = str_replace("index.php","",dc_blog_url);
		
		
		

		$code = '&lt;object type="application/x-shockwave-flash" data="'.$blogUrl.'ecrire/tools/dcVideo/dcVideoPlayer_p.swf" width="'.$width.'" height="'.$height.'"&gt;<br/>'
				 .'&lt;param name="movie" value="'.$blogUrl.'ecrire/tools/dcVideo/dcVideoPlayer_p.swf" /&gt;<br/>'
				 .'&lt;param name="bgcolor" value="'.$bgColor.'" /&gt;<br/>'
				 .'&lt;/object&gt;<br/>';

		
	if ($displayCenter=="1") {
			
		$code = '&lt;center&gt;'.$code.'&lt;/center&gt;';						
		}	
		
		return $code;
	}


}


?>